! -----------------------------------------------------------------
	program MAIN
! -----------------------------------------------------------------
!	2D Darcy
! -----------------------------------------------------------------
	implicit none
	integer Ne, Nn, Nb, Nm, Nd, Ng, NnNd		! array parameters
	integer iout, idbg, ipost
	integer lastA, lastB
	integer ldw
	real*8 Sx
	integer ipar(16), ipar0(16)			! bCGstab integer parameters array
	real*8 fpar(16), fpar0(16)			! bCGstab real    parameters array
	real*8 Ae(4,4), Be(4,4)				! element arrays
	real*8 Qde1(4)					! element arrays
	real*8 Qde2(4)					! element arrays
	integer, allocatable :: rA (:), rB (:)		! global  arrays (compact rows)
	integer, allocatable :: cA (:), cB (:)		! global  arrays (compact columns)
	integer, allocatable :: ie(:,:)			! global connectivity array
	integer, allocatable :: nmat(:,:)		! global nodal materials array
	integer, allocatable :: BCe(:,:), BCi(:)	! BC element and local element
						 	! face numbers
	real*8, allocatable :: BCn(:,:)			! BC N's
	real*8, allocatable :: BCvalue(:,:)		! BC value (j_bar, q_bar or c_bar)
	character*1, allocatable ::  BCtype(:)		! BC type ('N' or 'D')
	real*8, allocatable :: x(:,:)			! global coordinates array
	real*8, allocatable :: C   (:), T   (:)		! global  arrays
	real*8, allocatable :: Son (:)			! global  arrays
	real*8, allocatable :: Soe(:,:)			! element independent source nodal values
	real*8, allocatable :: vA (:), vB (:)		! global  arrays (compact values)
	real*8, allocatable :: D(:,:,:)			! global  arrays
	real*8, allocatable :: Rn(:), w(:), work(:)	! work arrays
	real*8, allocatable :: xg(:), wg(:)		! Gauss abscissas [-1,+1] and weights
	real*8, allocatable :: J(:,:,:,:), Ji(:,:,:,:), Jac(:,:), Jaci(:,:)
							! geometric entities
	real*8, allocatable :: Shp(:,:,:), dNdr(:,:,:,:)
							! shape functions
	real*8, allocatable :: Jib(:,:,:,:), a33(:)		! boundary geometric entities
	real*8, allocatable :: Shpb(:,:,:), dNdrb(:,:,:,:)	! boundary shape functions
	real	 time_begin, time_end

	integer Nr					! ### new parameters ###
	integer, allocatable :: order(:,:)		! ### new parameters ###
	real*8, allocatable ::  Rr(:)			! ### new parameters ###

	integer e, Nc

	data iout/3/, idbg/2/, ipost/4/
	data Nc/0/

	call CPU_TIME ( time_begin )

! open files
	open(iout, file='fout.txt', status='unknown')
	open(idbg, file='fdbg.txt', status='unknown')
	open(ipost,file='post.msh', status='unknown')

	write(idbg,'(a)') ' --- MAIN ---'	! ### TEMPORARY ###
	write(iout,*) '**********************************'	! version ID
	write(iout,*) '2D Darcy v54.3 of 02/09/18'		! version ID
	write(iout,*) '**********************************'	! version ID

! read parameters
	call READPARAM(iout, idbg, Ne, Nn, Nb, Nm, Nd, Ng)

! allocate arrays
	ldw  = 8*Nn	! storage for SPARSKIT BCGSTAB
	NnNd = 9*Nn	! 9 entries for 2D elements
	write(iout,*) 'ldw = ', ldw
	allocate ( ie(Ne,5), x(Nn,2), C(Nn), T(Nn), Rr(Nn), Son(Nn), Soe(Ne,4) )
	allocate ( vA(NnNd ), vB(NnNd ) )
	allocate ( rA(Nn+1) , rB(Nn+1)  )
	allocate ( cA(NnNd) , cB(NnNd)  )
	allocate ( D(Ne,2,2), nmat(Nn,0:Nd) )
	allocate ( Rn(Nn), w(Nn), work(ldw) )
	allocate ( xg(Ng), wg(Ng), J(2,2,Ng,Ng), Ji(2,2,Ng,Ng), Jac(Ng,Ng), Jaci(Ng,Ng) )
	allocate ( Shp(4,Ng,Ng), dNdr(4,2,Ng,Ng)  )
	allocate ( Jib(2,2,Nb,Ng), a33(Nb), Shpb(2,Nb,Ng), dNdrb(2,2,Nb,Ng) )
	allocate ( BCe(Nb,3), BCi(Nb), BCn(Nb,2), BCvalue(Nb,2), BCtype(Nb) )

	allocate (order(Nn,0:1))			! ### new parameter ###

! read input
	call READIN(iout, idbg, ipost, Ne, Nn, Nb, Nm, Ng, NnNd, ldw, &
			Sx, ie, &
			x, C, D, xg, wg, BCe, BCi, BCvalue, BCtype, Soe, &
			vA, vB, ipar, fpar, &
			rA, rB, &
			cA, cB, &
			lastA, lastB)

! Build a matrix of materials at each node
	call NODALMAT(iout, idbg, Ne, Nn, Nd, ie, nmat)

	ipar0 = ipar	! store the original ipar
	fpar0 = fpar	! store the original fpar

! loop on elements
	do e = 1, Ne

! calculate element shape functions
	  call SHAPE(iout, idbg, Ne, Nn, Ng, ie, x, xg, e, &
			  Shp, dNdr, J, Jac, Ji, Jaci)
! calculate element matrices
	  call SHAPEM(iout, idbg, Ne, Ng, Sx, D, &
			 Ae, Be, wg, e, Shp, dNdr, Jac, Ji)

! assemble arrays
	  call ASSEMBLE(iout, idbg, Ne, Nn, Nd, NnNd, &
			vA, vB, &
			rA, rB, &
			cA, cB, &
			lastA, lastB, &
			Ae, Be, ie, e)

	enddo	! e

! initialize
	call INIT(iout, idbg, Ne, Nn, Nb, Nm, Nd, NnNd, &
			BCe, BCi, BCn, BCvalue, BCtype, ie, x, nmat, &
			C, &
			vB, &
			rB, &
			cB, &
			lastB, &
			Nr, order, Rr)		! ### new parameters ###

! calculate the independent source [A]{So} (time-independent)
	call SOURCE0(iout, idbg, Ne, Nn, NnNd, ie, Soe, vA, rA, cA, lastA, Son)
	deallocate (Soe)

! calculate element shape functions on boundary faces
	call SHAPEB(iout, idbg, Ne, Nn, Nb, Ng, Sx, BCe, Bci, ie, x, xg, &
			  Jib, a33, Shpb, dNdrb)

	call CPU_TIME ( time_end )
	write (iout,*) 'Initialization time=', time_end - time_begin, ' seconds'

! update BC
	call BC(iout, idbg, Nn, Nb, Ng, BCe, BCvalue, BCtype, &
			T, Son, wg, a33, Shpb)

! solve equations and update
	call SOLVE(iout, idbg, Nn, Nb, NnNd, ldw, &
			ipar, fpar, ipar0, fpar0, &
			BCe, BCvalue, BCtype, C, T, Rn, &
			vB, rB, cB, lastB, &
			work, &
			Nr, order, Rr)		! ### new parameters ###

! write solver output, C, T and nodal fluxes
	call OUT(iout, idbg, ipost, Ne, Nn, &
			Nc, C, T, w, &
			ie, Qde1, Qde2, x, D)	

	call CPU_TIME ( time_end )
	write (iout,*) 'Total time=', time_end - time_begin, ' seconds'

	end
